<?php
include("db.php");

// Start the session
session_start();

// Set content type to JSON
header('Content-Type: application/json');

// Ensure the request method is GET
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    // Check if "Remember Me" cookie is set
    if (isset($_COOKIE['remember_me'])) {
        $token = $conn->real_escape_string($_COOKIE['remember_me']); // Protect against SQL injection

        // Verify the token in the database
        $tokenSql = "SELECT Id, Username FROM user_login WHERE Remember_token = '$token' LIMIT 1";
        $result = $conn->query($tokenSql);

        // Check if a matching user is found
        if ($result && $result->num_rows > 0) {
            $user = $result->fetch_assoc();

            // Automatically log the user in
            $_SESSION['user_id'] = $user['Id'];
            $_SESSION['username'] = $user['Username'];

            // Respond with a success message
            echo json_encode([
                'status' => 'success',
                'message' => 'Automatic login successful',
                'data' => [
                    'user_id' => $user['Id'],
                    'username' => $user['Username']
                ]
            ]);
        } else {
            // Invalid token or no matching user
            echo json_encode(['status' => 'error', 'message' => 'Invalid Remember Me token']);
        }
    } else {
        // No "Remember Me" cookie found
        echo json_encode(['status' => 'error', 'message' => 'No Remember Me token found']);
    }
} else {
    // Reject requests that are not GET
    echo json_encode(['status' => 'error', 'message' => 'Only GET method is allowed']);
}

// Close the database connection
$conn->close();
?>
